"use client";
import { FaGlassWater } from "react-icons/fa6";
import chack from "../../../../public/icons/checkPlans.svg";
import plusSquare from "../../../../public/icons/tick-square.svg";
import Image from "next/image";
import { motion, AnimatePresence } from "framer-motion";

export default function Plans({ items = [], planKind }) {
    const period = Object.entries(items).map(([id, data]) => ({
        id,
        data,
    }));

    return (
        <>
            <AnimatePresence mode="wait">
                {period?.map((p) =>
                    p?.id === planKind ? (
                        <motion.div
                            key={p.id}
                            initial={{ opacity: 0, y: 20 }}
                            animate={{ opacity: 1, y: 0 }}
                            exit={{ opacity: 0, y: -10 }}
                            transition={{ duration: 0.3 }}
                            style={{
                                gridTemplateColumns: `repeat(${p.data?.length || 1}, minmax(0, 1fr))`,
                            }}
                            className="grid gap-9 pt-8 pb-9 px-28 xl:px-12 lg:scroll-auto lg:overflow-x-auto lg:overflow-y-hidden lg:flex lg:mb-10 lg:pt-2 lg:px-6"
                        >
                            {p.data?.map((item, idx) => (
                                <motion.div
                                    key={idx}
                                    initial={{ opacity: 0, y: 30 }}
                                    animate={{ opacity: 1, y: 0 }}
                                    exit={{ opacity: 0, y: -30 }}
                                    transition={{ duration: 0.3, delay: idx * 0.1 }}
                                    className="relative bg-white shadow-[4px_4px_20px_rgba(0,0,0,0.4)] pt-8 pb-9 pl-6 pr-6 flex flex-col justify-between gap-9 text-secondary-main w-full -mt-[125px] rounded-2xl xl:px-4 lg:mt-0 lg:gap-6 lg:py-4 lg:min-w-[300px] lg:translate-y-0"
                                >
                                    <div className="grid gap-9">
                                        <div className="border border-primary-main bg-primary-main/10 rounded-xl w-fit p-4">
                                            <FaGlassWater />
                                        </div>

                                        <div className="font-extrabold text-t2 lg:text-t3">{item?.title}</div>

                                        <ul className="grid gap-7 lg:gap-4">
                                            {item?.includes_prev && (
                                                <li className="flex items-center justify-start gap-2 lg:text-sm lg:leading-6">
                                                    <Image src={plusSquare} alt="" width={25} height={25}/>
                                                    <span>تمامی امکانات پلن قبلی</span>
                                                </li>
                                            )}
                                            {item?.features?.map((option, i) => (
                                                <li
                                                    key={i}
                                                    className="flex items-center justify-start gap-2 lg:text-sm lg:leading-6"
                                                >
                                                    <Image src={chack} alt="" width={25} height={25}/>
                                                    <span>{option?.name}</span>
                                                </li>
                                            ))}
                                        </ul>
                                    </div>

                                    <div className="grid grid-cols-2 justify-between lg:grid-cols-1">
                                        <div>
                                            <div className="flex items-center justify-between">
                                                <del className="text-muted text-[16px]">
                                                    {item?.price_before}
                                                </del>
                                                {item?.discount_percent && (
                                                    <span className="py-0.5 px-4 bg-danger-main rounded-xl rounded-bl-none text-white text-subT1 font-bold">
                                                        {item?.discount_percent}%-
                                                    </span>
                                                )}
                                            </div>
                                            <div className="flex flex-wrap items-center gap-2 lg:gap-3">
                                                <p className="font-extrabold text-t1 text-right lg:text-t2">
                                                    {item.price_after}
                                                </p>
                                                <p className="text-primary-main text-[10px] mt-2">
                                                    تومان / {item.period}
                                                </p>
                                            </div>
                                            {item.period !== "سالانه" && (
                                                <div className="text-[12px] text-muted font-medium">
                                                    <span>مبلغ سالانه {item.total_amount}</span>
                                                </div>
                                            )}
                                        </div>

                                        <div className="mt-auto mx-auto text-white text-[15px] lg:text-sm">
                                            {item?.status ? (
                                                <button className="py-4 px-2 bg-secondary-main rounded-[10px] lg:px-4 lg:py-3">
                                                    افزودن به سبد خرید
                                                </button>
                                            ) : (
                                                <button className="px-11 py-4 bg-muted rounded-[10px] lg:py-3">
                                                    به زودی!
                                                </button>
                                            )}
                                        </div>
                                    </div>
                                </motion.div>
                            ))}
                        </motion.div>
                    ) : null
                )}
            </AnimatePresence>

            <div className="flex flex-col gap-4 w-full">
                <p className="text-t2 font-black text-secondary-main border-b-2 border-primary-main mx-auto md:text-t3">
                    آیا پلن سازمانی میخواهید؟
                </p>
                <p className="mx-auto text-center lg:px-6 leading-9">
                    برای دسترسی‌های بیشتر و همچنین درخواست اشتراک‌های چندکاربره تنها کافیست
                    باما تماس بگیرید
                </p>
                <button className="bg-primary-main rounded-xl p-4 mx-auto">
                    تماس با راوی حساب
                </button>
            </div>
        </>
    );
}
