"use client"
import DropdownTable from "@/app/exam/step4/_component/dropdownTable";
import Container from "@/components/ui/container/container";
import {useEffect, useState} from "react";
import {GET} from "@/services/axios/resources/resourcesAPI";
import Link from "next/link";


export default function Page() {

    const [data, setData] = useState([])


    function getApi() {

        GET("api/admin/exam-management/exams/show-exams")
            .then(res => {
                setData(res.data.data)
            })
            .catch(err => {
            })
            .finally()

    }

    useEffect(() => {
        getApi()
    }, [])

    return (
        <Container>

            <div className="flex flex-col gap-4 mt-10">

                {data?.map((item, index) => (
                    <Link href={`/exam/step1/${item.id}`} className="inline-block border-2 text-nowrap border-primary-main rounded-md ">
                        <div
                            className="flex items-center  justify-between bg-primary-lighten rounded-lg px-4 py-2 md:py-4 md:scroll-auto md:overflow-x-auto md:overflow-y-auto md:text-sm">

                            <div className="flex gap-3 font-bold text-[18px]">

                                <p>{item.title}</p>
                                <span className="border-l border-muted"></span>

                                <div className="flex gap-2">
                                    <p>درصد پاسخگویی:</p>
                                    <p className="font-normal">{item.passing_score_present}</p>
                                </div>


                            </div>

                            <button
                                className="border-2 flex justify-center px-1 border-black rounded-lg text-[17px] text-black bg-transparent md:mx-6 md:px-5 md:py-1.5">مشاهده
                            </button>
                        </div>
                    </Link>


                ))}


            </div>

        </Container>
    )
}