"use client";

import Container from "@/components/ui/container/container";
import Image from "next/image";
import logo from "../../../../public/icons/logo.svg";
import Table from "@/app/exam/step4/_component/table";
import Chart from "@/app/exam/step4/_component/chart";
import DropdownTable from "@/app/exam/step4/_component/dropdownTable";
import { GET } from "@/services/axios/resources/resourcesAPI";
import { useCallback, useEffect, useState } from "react";
import toast from "react-hot-toast";
import LoadingOverlay from "@/components/ui/Loading/LoadingOverlay";
import Link from "next/link";

export default function Page() {
    const sampleData = [
        { date: "1404/05/01", value: 34.5 },
        { date: "1404/05/12", value: 54.5 },
        { date: "1404/05/23", value: 78.5 },
        { date: "1404/06/04", value: 12.5 },
    ];

    const [examInfo, setExamInfo] = useState(null);
    const [examName, setExamName] = useState("");
    const [loading, setLoading] = useState(true);
    const [data, setData] = useState([]);

    // ✅ بارگذاری داده‌ها از localStorage بعد از mount
    useEffect(() => {
        try {
            const info = JSON.parse(localStorage.getItem("exam_info"));
            const name = JSON.parse(localStorage.getItem("examName"));
            if (info) setExamInfo(info);
            if (name) setExamName(name);
        } catch (err) {
            console.error("Failed to read localStorage:", err);
        }
    }, []);

    // ✅ فراخوانی API بعد از آماده شدن examInfo
    useEffect(() => {
        if (!examInfo) return;

        setLoading(true);
        GET(`/api/exam/result/${examInfo.exam_attempt_id}`)
            .then((res) => {
                    setData(res.data)
                    console.log(res)
                })
            .catch((err) => console.error("Failed to fetch exam results:", err))
            .finally(() => setLoading(false));
    }, [examInfo]);

    // ✅ تابع دانلود فایل از API
    // async function handleDownload () {
    //     if (!examInfo?.exam_attempt_id) {
    //         toast.error("شناسه آزمون معتبر نیست.");
    //         return;
    //     }
    //
    //     try {
    //         const res = await GET(`/api/exam/download-answers/${examInfo.exam_attempt_id}?export=excel`);
    //
    //         console.log(res)
    //         if (!res.ok) {
    //             throw new Error("دانلود با خطا مواجه شد.");
    //         }
    //
    //         const blob = await res.blob();
    //         const url = window.URL.createObjectURL(blob);
    //         const a = document.createElement("a");
    //         a.href = url;
    //
    //         // 🧠 نام فایل از header
    //         const disposition = res.headers.get("Content-Disposition");
    //         const match = disposition && disposition.match(/filename="?([^"]+)"?/);
    //         const filename = match ? match[1] : "exam-answers.zip";
    //
    //         a.download = filename;
    //         document.body.appendChild(a);
    //         a.click();
    //         a.remove();
    //         window.URL.revokeObjectURL(url);
    //     } catch (error) {
    //         console.error(error);
    //         toast.error("مشکلی در دانلود فایل پیش آمد.");
    //     }
    // };

    if (loading) {
        return (
            <div className="flex flex-col gap-4">
                <LoadingOverlay />
            </div>
        );
    }

    return (
        <Container className="py-12 md:p-2">
            <div className="flex flex-col gap-14">
                {/* Header */}
                <div className="flex md:flex-col md:gap-3 md:items-center justify-between">
                    <div className="flex gap-2 items-center justify-evenly">
                        <Image src={logo} alt="logo" width={34} />
                        <p className="font-black text-t2 md:text-body border-b-2 border-secondary-main text-secondary-main">
                            {examName || data.exam_title || "-"}
                        </p>
                    </div>

                    <Link
                        href={`https://ravi1.arvinidea.com/api/exam/download-answers/${examInfo.exam_attempt_id}?export=excel`}
                        className="text-[18px] md:text-subT2 font-bold text-white rounded-lg bg-info-main p-2 md:py-3 md:px-5 hover:bg-info-dark transition-all"
                    >
                        دانلود سوالات خام و کلید آزمون
                    </Link>
                </div>

                {/* جدول خلاصه آزمون */}
                <Table
                    headers={[
                        "ردیف",
                        "سر فصل های آزمون",
                        "ضریب",
                        "تعداد سوال",
                        "تعداد پاسخ",
                        "تعداد پاسخ درست",
                        "تعداد پاسخ اشتباه",
                        "درصد کسب شده",
                        "حد نصاب قبولی",
                    ]}
                    rows={data.part_1_section_summary?.map((item, index) => [
                        index + 1,
                        item.title || "-",
                        item.weight ?? "-",
                        item.question_count ?? "-",
                        (item.correct_answers ?? 0) + (item.wrong_answers ?? 0),
                        item.correct_answers ?? 0,
                        item.wrong_answers ?? 0,
                        `%${item.present_score ?? 0}`,
                        `%${item.passing_score_prsent ?? 0}`,
                    ]) || []}
                    footer={
                        <div className="flex gap-3 font-bold text-[18px]">
                            <p>نتیجه نهایی آزمون</p>
                            <span className="border-l border-muted"></span>
                            <div className="flex gap-2">
                                <p>درصد پاسخگویی بر اساس ضریب:</p>
                                <p className="font-normal">%{data.final_score}</p>
                            </div>
                            {/*<span className="border-l border-muted"></span>*/}
                            {/*<div className="flex gap-2">*/}
                            {/*    <p>حدنصاب قبولی:</p>*/}
                            {/*    <p className="font-normal">%{data.}</p>*/}
                            {/*</div>*/}
                            <span className="border-l border-muted"></span>
                            <div className="flex gap-2">
                                <p>وضعیت آزمون:</p>
                                <p className="border-b-2  ">{data.final_status === "Failed" ? "مردود" : "قبول"}</p>
                            </div>
                        </div>
                    }
                />

                {/* جزئیات سوالات */}
                <div className="flex flex-col gap-4">
                    <p className="font-black text-t2 text-black md:text-xl">تحلیل و بررسی پاسخ ها و سوالات</p>
                    {data.part_2_question_details?.map((items, index) => (
                        <DropdownTable key={index} items={items} index={index} />
                    )) || <p>اطلاعاتی برای نمایش وجود ندارد.</p>}
                </div>

                {/*/!* جدول تحلیل رشد و افت *!/*/}
                {/*<div className="flex flex-col gap-4">*/}
                {/*    <p className="font-black text-t2 text-black md:text-xl">جدول تحلیل و بررسی رشد و افت شما</p>*/}
                {/*    <Table*/}
                {/*        headers={[*/}
                {/*            "تاریخ آزمون",*/}
                {/*            "تعداد سوال",*/}
                {/*            "تعداد پاسخ",*/}
                {/*            "تعداد پاسخ درست",*/}
                {/*            "تعداد پاسخ اشتباه",*/}
                {/*            "درصد کسب شده",*/}
                {/*            "وضعیت آزمون",*/}
                {/*        ]}*/}
                {/*        rows={ data.part_3_section_summary?.map((item) => [*/}
                {/*             item.date ?? "-",*/}
                {/*            item.question_count ?? "-", // تعداد سوالات*/}
                {/*            item.answered_question_count ?? "-", // تعداد پاسخ داده شده*/}
                {/*            item.correct_answer_count ?? 0, // تعداد پاسخ درست*/}
                {/*            item.wrong_answer_count ?? 0, // تعداد پاسخ اشتباه*/}
                {/*            `%${item.present_score ?? 0}`, // درصد کسب شده*/}
                {/*            item.status ?? "-", // وضعیت آزمون*/}
                {/*        ]) || []}*/}
                {/*        footer={*/}
                {/*            <div className="flex gap-3 font-bold text-[18px]">*/}
                {/*                <p>نتیجه نهایی آزمون</p>*/}
                {/*                <span className="border-l border-muted"></span>*/}
                {/*                <div className="flex gap-2">*/}
                {/*                    <p>درصد پاسخگویی بر اساس ضریب:</p>*/}
                {/*                    <p className="font-normal">%72.2</p>*/}
                {/*                </div>*/}
                {/*                <span className="border-l border-muted"></span>*/}
                {/*                <div className="flex gap-2">*/}
                {/*                    <p>حدنصاب قبولی:</p>*/}
                {/*                    <p className="font-normal">%50</p>*/}
                {/*                </div>*/}
                {/*            </div>*/}
                {/*        }*/}
                {/*    />*/}
                {/*</div>*/}

                {/* نمودار رشد و افت */}
                <div className="flex flex-col gap-4">
                    <p className="font-black text-t2 text-black md:text-xl">نمودار تحلیل و بررسی رشد و افت شما</p>
                    <div className="flex items-center w-full justify-center">
                        <Chart dataChart={sampleData} />
                    </div>
                </div>
            </div>
        </Container>
    );
}
