import axios from 'axios';
import ResponseErrorHandel from "../ReponseErrorHandeler/StatusHandel.js";


const apiRequests = axios.create({
    baseURL: "https://ravi1.arvinidea.com",
    headers: {
        'Content-Type': 'application/json',
    },
})

export default apiRequests;


apiRequests.interceptors.request.use(
    config => {
        if (typeof window !== 'undefined') {
            const token = localStorage.getItem('accessToken');
            if (token) config.headers.authorization = `Bearer ${token}`;
        }
        return config;
    },
    error => Promise.reject(error)
);


apiRequests.interceptors.response.use(
    (res) => {
        return res.data;
    },

    error => {
        ResponseErrorHandel(error)
        return Promise.reject(error)
    }
)



