"use client";
import {useEffect, useState} from "react";
import axios from "axios";
import {motion} from "framer-motion";
import IntroContainer from "./_component/IntroContainer";
import InputContainer from "../../components/ui/InputContainer/InputContainer";
import CalculatBenefitContainer from "../../components/ui/Benefit/Benefit";
import AdvancedOptions from "../../components/ui/AdvancedOptions/AdvacedOptions";
import CalculationTable from "../../components/ui/CalculationTable/CalculationTable";
import PayrollOption from "../../components/ui/PayrollOption/PayrollOption";
import LoadingOverlay from "@/components/ui/Loading/LoadingOverlay";
import Actions from "@/components/ui/Actions/Actions";


export default function InnovativeIdeasPage() {

    const [pageName, setPageName] = useState("");
    const [coverImageUrl, setCoverImageUrl] = useState("");
    const [videoUrl, setVideoUrl] = useState("");

    const [formsData, setFormsData] = useState([]);

    const [requiredFields, setRequiredFields] = useState([]);
    const [actionFields, setActionFields] = useState([]);
    const [requiredFieldValues, setRequiredFieldValues] = useState({});
    const [requiredFieldErrors, setRequiredFieldErrors] = useState({});
    const [advancedFields, setAdvancedFields] = useState([]);
    const [selectedAdvancedInputs, setSelectedAdvancedInputs] = useState([]);

    const [methodItems, setMethodItems] = useState([]);
    const [selectedMethod, setSelectedMethod] = useState({id: "0", name: "مبنای ماهانه", value: "آیتم های حقوق"});

    const [outputFields, setOutputFields] = useState([]);
    const [outputFieldsResponse, setOutputFieldsResponse] = useState([]);

    const benefits = "استانداردهای حسابداری شماره ۱ و ۲، دو استاندارد مهم حسابداری هستند که آشنایی با آنها، برای حسابداران و مدیران مالی ضروری است. این دوره آموزشی، به شما کمک می‌کند تا با این دو استاندارد به طور کامل آشنا شوید و مهارت‌های لازم برای تهیه و ارائه صورت‌های مالی و صورت جریان‌های نقدی را کسب کنید. در صورت تمایل به تسلط به امور مالیاتی و آموزش مالیات جامع شما می توانید از طریق همین سایت به قسمت مربوطه مراجعه کنید. همچنین در صورت تمایل به آموزش قوانین مالیاتی جدید به قسمت مربوطه مراجعه کنید تا همیشه به روز باشید" +
        "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد کتابهای زیادی در شصت و سه درصد گذشته حال و آینده شناخت فراوان جامعه و متخصصان را می طلبد";


    const [loading, setLoading] = useState(true);
    const [apiData, setApiData] = useState([])
    const getApi = async () => {

        setLoading(true);
        try {
            const response = await axios.get("https://www.vakilodoleh.ir/api/forms/salary/schema");
            const data = response.data;
            setApiData(data);


            if (data.forms && data.forms.length > 0) {
                setFormsData(data.forms);

                // فرم پیش‌فرض (اولی)
                const firstForm = data.forms[0];
                applyFormData(firstForm);

                const methods = data.forms.map(item => ({
                    id: item.form.id,
                    name: item.form.title,
                    slug: item.form.slug
                }));

                setMethodItems(methods);
                setSelectedMethod(methods[0]); // انتخاب اولیه
            }
        } catch (error) {
            console.error("API Error:", error);
        } finally {
            setLoading(false);
        }
    };


    const applyFormData = (formData) => {

        const imageField = formData.form.metaFields.find((field) => field.name === "image");
        const videoField = formData.form.metaFields.find((field) => field.name === "video");
        const topHeaderField = formData.form.metaFields.find((field) => field.name === "top_header");

        setCoverImageUrl(imageField?.text || "");   // برای پاس دادن به IntroContainer
        setVideoUrl(videoField?.text || "");        // برای پاس دادن به IntroContainer
        setPageName(topHeaderField?.text || "");    // برای پاس دادن به IntroContainer
    };

    useEffect(() => {
        if (!selectedMethod || !apiData?.forms) return;

        const selectedForm = apiData.forms.find(
            (f) => f.form.id === selectedMethod.id
        );

        if (!selectedForm) return;

        const sections = selectedForm.sections || [];
        const actions = selectedForm.actions || []


        // موارد الزامی
        const requiredSection = sections.find(
            (section) => section.title === "موارد الزامی"
        );

        if (requiredSection) {
            const formatted = requiredSection.fields.map((field) => ({
                id: field.id,
                name: field.label,
                excelKey: field.excelKey,
                placeHolder: field.placeholder,
                type: field.type,
                active: true,
                ...(field.options && {options: field.options})
            }));
            setRequiredFields(formatted);
        } else {
            setRequiredFields([]);
        }

        // موارد پیشرفته
        const advancedSection = sections.find(
            (section) => section.title === "موارد پیشرفته"
        );

        if (advancedSection) {
            const formattedAdvanced = advancedSection.fields.map((field) => ({
                id: field.id,
                name: field.label,
                excelKey: field.excelKey,
                description: field.help || "",
                placeholder: field.placeholder,
                type: field.type,
                ...(field.options && {options: field.options})
            }));
            setAdvancedFields(formattedAdvanced);
        } else {
            setAdvancedFields([]);
        }


        setActionFields(actions)

    }, [selectedMethod, apiData]);


    useEffect(() => {
        if (formsData.length > 0) {
            const selectedForm = formsData.find(f => f.form.id === selectedMethod.id);
            if (selectedForm) {
                applyFormData(selectedForm);
            }
        }
    }, [selectedMethod]);


    useEffect(() => {
        getApi();
    }, []);


    useEffect(() => {
        if (!selectedMethod || !apiData?.forms) return;

        const selectedForm = apiData.forms.find(
            (f) => f.form.id === selectedMethod.id
        );

        if (!selectedForm) return;

        const outputs = selectedForm.outputs || [];

        // تبدیل ساختار outputs به چیزی که CalculationTableData بفهمه
        const formattedOutputs = outputs.map(output => ({
            id: output.id,
            title: output.title,
            result: "", // می‌تونی بعداً محاسبه‌شده‌ها رو بذاری
            bold: output.bold || false,
            class: output.class,
            group_id: output.group_id,
        }));

        setOutputFields(formattedOutputs);

    }, [selectedMethod, apiData]);


    return (
        <>
            {loading ? (
                <LoadingOverlay/>
            ) : (
                <div>
                    {/* ✅ بخش ابتدایی: IntroContainer */}
                    <IntroContainer
                        pageName={pageName}
                        coverImageUrl={coverImageUrl}
                        videoUrl={videoUrl}
                    />


                    {/* ✅ سایر بخش‌های صفحه */}
                    <div
                        className="grid grid-cols-5 px-32 py-16 bg-box gap-[26px] xl:grid-cols-1 xl:px-16 md:px-8 md:py-0">
                        <div className="col-span-3 flex flex-col gap-6 xl:col-span-1">
                            <PayrollOption
                                pageName={pageName}
                                items={methodItems}
                                setMethod={setSelectedMethod}   // این متد state صفحه اصلی رو آپدیت می‌کنه
                            />


                            <InputContainer
                                item={{value: selectedMethod?.name}}   // همون تیتر بالای فرم
                                setRequiredFieldValues={setRequiredFieldValues}
                                requiredFieldValues={requiredFieldValues}
                                requiredFieldErrors={requiredFieldErrors}
                                selectedInputs={selectedAdvancedInputs}  // موارد پیشرفته انتخاب‌شده
                                requiredFields={requiredFields}          // موارد الزامی
                            />

                            <Actions actions={actionFields[0]} setOutputFieldsResponse={setOutputFieldsResponse}
                                     setRequiredFieldErrors={setRequiredFieldErrors}
                                     requiredFieldValues={requiredFieldValues}/>

                            <motion.div
                                layout
                                transition={{type: "spring", stiffness: 300, damping: 30}}
                            >
                                <AdvancedOptions
                                    name="موارد پیشرفته"
                                    items={advancedFields}
                                    setSelectedOptions={setSelectedAdvancedInputs}
                                />

                            </motion.div>
                        </div>

                        <div className="col-span-2 xl:col-span-1">
                            <CalculationTable
                                actions={actionFields}
                                outputFieldsResponse={outputFieldsResponse}
                                pageName={pageName}
                                item={outputFields}
                            />

                        </div>
                    </div>

                    <CalculatBenefitContainer
                        pageName={pageName}
                        benefits={benefits}
                    />
                </div>
            )}
        </>
    );
}
