"use client"
import { FaAngleLeft } from "react-icons/fa";
import {useRef, useState} from "react";

export default function IntroContainer({ pageName, coverImageUrl, videoUrl }) {
    const [isPlaying, setIsPlaying] = useState(false);
    const videoRef = useRef(null);

    const handlePlay = () => {
        setIsPlaying(true);
        videoRef.current?.play();
    };

    return (
        <div className="w-full relative grid grid-cols-2 bg-white gap-16 px-24 pt-12 pb-16 xl:px-16 lg:flex lg:flex-col md:px-8">
            {/* تزئینات زمینه */}
            <div className="absolute -right-2 top-10 h-60 w-36 blur-2xl bg-primary-main/20 rounded-bl-full rounded-tl-full md:hidden"></div>
            <div className="absolute left-0 top-32 h-60 w-24 blur-2xl bg-primary-main/15 rounded-br-full rounded-tr-full md:hidden"></div>

            {/* بخش متن */}
            <div className="col-span-1 flex flex-col gap-6 justify-start items-start">
                {/* مسیر ناوبری بالا */}
                <div className="md:hidden flex gap-2 items-center">
                    <p className="text-nowrap text-muted">صفحه اصلی</p>
                    <FaAngleLeft />
                    <p className="text-nowrap text-secondary-main">{pageName}</p>
                </div>

                {/* تیتر اصلی */}
                <h1 className="text-right md:text-right md:text-t3 text-[30px] leading-[55px] text-secondary-main font-extrabold">
                    محاسبه آنلاین - <span className="text-primary-main">{pageName}</span>
                </h1>

                {/* متن توضیحی ثابت یا قابل تغییر در آینده */}
                <p className="text-muted text-[15px] text-justify justify-start leading-[45px] md:justify-center md:text-md md:leading-[45px]">
                    در این بخش، علاوه بر دسترسی به جدیدترین جدول ضرایب مالیاتی اینتاکد، می‌توانید مالیات فعالیت یا
                    کالای موردنظر خود را به‌صورت آنلاین و دقیق بر اساس ضرایب تعریف‌شده محاسبه کنید.
                </p>
            </div>

            {/*بخش تصویر و ویدیو*/}
            <div className="relative w-full aspect-video rounded-xl overflow-hidden">
                {!isPlaying && (
                    <div onClick={handlePlay} className="absolute inset-0 cursor-pointer">
                        <img src={coverImageUrl || "#"} alt="Cover" className="w-full h-full object-cover" />
                        <div className="absolute inset-0 flex items-center justify-center">
                            <svg
                                xmlns="http://www.w3.org/2000/svg"
                                fill="white"
                                viewBox="0 0 24 24"
                                className="w-16 h-16 opacity-0 hover:scale-110 transition-transform"
                            >
                                <path d="M8 5v14l11-7z" />
                            </svg>
                        </div>
                    </div>
                )}
                <video
                    ref={videoRef}
                    src={videoUrl || "#"}
                    controls
                    className={`w-full h-full ${isPlaying ? "block" : "hidden"}`}
                />
            </div>
        </div>
    );
}
