export default function Table({ headers = [], rows = [], footer }) {
    return (
        <div className="overflow-x-auto  md:scroll-auto md:overflow-x-auto md:overflow-y-auto">
            <div className="rounded-xl overflow-hidden border-2 w-full border-primary-main  md:scroll-auto md:overflow-x-auto md:overflow-y-auto">
                <table className="table-auto w-full text-center  md:scroll-auto md:overflow-x-auto md:overflow-y-auto">
                    <thead>
                    <tr className="border-b-2 border-black text-[18px] font-black">
                        {headers.map((header, index) => (
                            <th
                                key={index}
                                className={`p-3 text-nowrap w-1/${headers.length} relative`}
                            >
                                {index !== headers.length - 1 && (
                                    <span className="absolute left-0 h-[1.5em] border-l border-muted"></span>
                                )}
                                {header}
                            </th>
                        ))}
                    </tr>
                    </thead>
                    <tbody>
                    {rows.map((row, rowIndex) => (
                        <tr key={rowIndex} className="odd:bg-box even:bg-white">
                            {row.map((cell, cellIndex) => (
                                <td
                                    key={cellIndex}
                                    className={`p-3 text-nowrap ${
                                        cellIndex === 0 ? "pr-8 text-right" : ""
                                    }`}
                                >
                                    {cell}
                                </td>
                            ))}
                        </tr>
                    ))}

                    {footer && (
                        <tr>
                            <td
                                className="border-t-2 font-bold text-[18px] text-right bg-primary-lighten border-primary-main py-2 px-6"
                                colSpan={headers.length}
                            >
                                {footer}
                            </td>
                        </tr>
                    )}
                    </tbody>
                </table>
            </div>
        </div>
    );
}
