import CalculationTableData from "../CalculationTableData/CalculationTableData";
import Actions from "@/components/ui/Actions/Actions";

export default function CalculationTable({pageName, item, actions, outputFieldsResponse}) {


    console.log(outputFieldsResponse);

    return (
        <div className="border-[1.5px] border-muted p-4 rounded-2xl flex flex-col justify-center gap-6">

            <div className="font-extrabold text-xl text-secondary-main">
                جدول محاسبات {pageName}
            </div>

            <div className="flex flex-col px-6 py-4 bg-white rounded-xl">


                <CalculationTableData items={outputFieldsResponse?.length > 0 ? outputFieldsResponse : item}/>

                {/*<hr className="h-0.5 bg-secondary-main w-full mt-6"/>*/}
                {/*<span className="mt-6"></span>*/}
                {/*<ShowData items={item2} color={"red-600"}/>*/}

                {/*<hr className="h-0.5 bg-secondary-main w-full mt-6"/>*/}
                {/*<span className="mt-6"></span>*/}
                {/*<ShowData items={item3}/>*/}
                {/*<span className="mb-6"></span>*/}

                <div className="flex flex-col gap-6 mt-6">

                    <Actions actions={actions?.[1]} requiredFieldValues={{}}/>

                    <div className="text-secondary-main text-md sm:text-justify sm:text-sm">
                        برای دریافت ریز حقوق لطفا
                        <span className="font-bold"> فیش حقوقی </span>
                        را دریافت نمایید!
                    </div>
                </div>

            </div>
        </div>
    )
};