import toast from "react-hot-toast";



export default function ResponseErrorHandel(error) {


    const status = error?.response?.status ?? null;
    const message =
        error?.response?.data?.message ??
        error?.response?.data?.en_message ??
        "خطای ناشناخته‌ای رخ داد";

    if (error.message.includes("timeout")) {
        toast.error("خطای انتظار لطفا دوباره تلاش کنید..!");
        return;
    }

    if (!error?.response) {
        toast.error("خطای اینترنت دوباره تلاش کنید..!");
        return;
    }

    switch (status) {
        case 403:
        case 401:
            localStorage.clear();
            toast.error("ابتدا وارد شوید و سپس دوباره تلاش کنید!..");
            break;
        case 400:
        case 402:
        case 404:
        case 409:
            toast.error(message);
            break;
        default:
            if (status >= 500) {
                toast.error("خطای سرور داخلی");
            } else {
                toast.error(message);
            }
            break;
    }
}
